/*
 * \file: grl_bmpdec_fgs.h
 *
 *
 * This header file declares the functions that are provided by
 * the FGS Decoder Module
 *
 * \component: SVG Bitmap Decoder (SVGBMPDEC)
 *
 * \author: E. Friedrich (efriedrich@de.adit-jv.com)
 *
 * \copyright: (c) 2011 ADIT Corporation
 *
 */

#ifndef GRL_BMPDEC_FGS_H_
#define GRL_BMPDEC_FGS_H_

#include    "adit_typedef.h"
#include    "svg_bitmap_decoder.h"
#include    "svg_error.h"

#define FGS_HDR_SIZE             (8)
#define GRL_FGS_IDX_MAGIC_NO_0   (0)
#define GRL_FGS_IDX_MAGIC_NO_1   (1)
#define GRL_FGS_IDX_MAGIC_NO_2   (2)
#define GRL_FGS_IDX_MAGIC_NO_3   (3)
#define GRL_FGS_IDX_WIDTH_LO     (4)
#define GRL_FGS_IDX_WIDTH_HI     (5)
#define GRL_FGS_IDX_HEIGHT_LO    (6)
#define GRL_FGS_IDX_HEIGHT_HI    (7)

#define GRL_FGS_WIDTH_MAX        (2048)
#define GRL_FGS_HEIGHT_MAX       (2048)

/**
 * \fn    GRL_error   GRL_BMPDEC_draw_image_FGS( GRL_BMPDEC_dec_info *p_decode_info )
 *
 * Decodes and draws the image.
 *
 * \param   *p_decode_info  Pointer to decoding info
 *
 * \return  SVG_NO_ERROR    - No error occurred
 */
extern  SVGError   GRL_BMPDEC_draw_image_FGS( GRL_BMPDEC_dec_info *p_decode_info );

/**
 * \fn    SVGError   GRL_BMPDEC_get_image_info_FGS( const SVGContextBmpDec *bmp_ctx,
 *                                               const SVGImage         *p_image,
 *                                               SVGImageInfo           *image_info )
 *
 * Reads width and height out of the FGS image.
 *
 * \param   *bmp_ctx        The bitmap decoder context
 * \param   *p_image        Pointer to the image whose information should be returned
 * \param   *image_info     Pointer to the resulting image info structure
 *
 * \return  SVG_NO_ERROR    - No error occurred
 */
extern  SVGError   GRL_BMPDEC_get_image_info_FGS( const SVGContextBmpDec *bmp_ctx,
                                            const SVGImage         *p_image,
                                            SVGImageInfo           *image_info );

#endif /* GRL_BMPDEC_FGS_H_ */
